<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Models\Accommodation\Accommodations;
use App\Models\General\Companies;
use App\Models\General\Service;
use App\sys\SyncsWithTypes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Cache;
use Laravel\Sanctum\HasApiTokens;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements Auditable, JWTSubject
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use AuditableTrait, HasApiTokens, HasFactory, Notifiable, SyncsWithTypes;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'first_name',
        'last_name',
        'phone',
        'email',
        'password',
        'is_active',
        'employee_number',
        'role_id',
        'is_supplier',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function account_mappings()
    {
        return $this->hasMany(UserAccountMapping::class, 'user_id');
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'service_user', 'user_id', 'service_id')->withPivot('type');
    }

    public function accommodations()
    {
        return $this->belongsToMany(Accommodations::class, 'ac_accommodation_user', 'user_id', 'ac_accommodation_id')->withPivot('type');
    }

    public function groups()
    {
        return $this->belongsToMany(Group::class, 'groups_user');
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

    public function companies()
    {
        return $this->belongsToMany(Companies::class, 'company_user', 'user_id', 'company_id');
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function overrides()
    {

        return $this->belongsToMany(Permission::class, 'user_permission_overrides')
            ->withPivot('override_type', 'function_name', 'collection_name');
    }

    // هنجيب ال permission list من الكاش فاهمني
    public function getRolePermissionsList(): array
    {

        // $cacheKey = 'user:' . $this->id . ':role_permissions';

        //  return Cache::rememberForever($cacheKey, function () {
        //     if (!$this->role) {
        //         return [];
        //     }

        if (! $this->role) {
            return [];
        }

        return $this->role->permissions()->pluck('permission_name')->toArray();
        // });
    }

    // هتجيب ال override rules من الكاش فاهمني
    public function getOverrideRulesList(): array
    {

        // $cacheKey = 'user:' . $this->id . ':overrides';

        // return Cache::rememberForever($cacheKey, function () {

        return $this->overrides
            ->pluck('pivot.override_type', 'permission_name')
            ->toArray();
        // });
    }

    // تمسح الكاش لما يتغير حاجة في الصلاحيات

    // public function clearPermissionCache(): void
    // {
    //     Cache::forget('user:' . $this->id . ':role_permissions');
    //     Cache::forget('user:' . $this->id . ':overrides');
    // }

}
