<?php

namespace App\Rules;

use App\Models\General\ServicesTranslation;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueServiceTranslation implements ValidationRule
{
    protected $servicesId;

    protected $excludeId;

    public function __construct($servicesId, $excludeId = null)
    {
        $this->servicesId = $servicesId;
        $this->excludeId = $excludeId;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $query = ServicesTranslation::where('services_id', $this->servicesId)
            ->where('lang_id', $value);

        if ($this->excludeId) {
            $query->where('id', '!=', $this->excludeId);
        }

        if ($query->exists()) {
            $fail('This language is already translated for this service.');
        }
    }
}
