<?php

namespace App\sys\Enums;

enum GroupEnum: int
{
    case ADMIN = 1;
    case ACCOUNTANT = 2;
    case ACCOUNTANT_MANAGER = 3;
    case SALES = 4;
    case SALES_MANAGER = 5;
    case RESERVATION = 6;
    case RESERVATION_MANAGER = 7;
    case HANDLING = 8;
    case HANDLING_MANAGER = 9;

    public function label(): string
    {
        return match ($this) {
            self::ADMIN => 'admin',
            self::ACCOUNTANT_MANAGER => 'accountant manager',
            self::ACCOUNTANT => 'accountant',
            self::SALES => 'sales',
            self::SALES_MANAGER => 'sales manager',
            self::RESERVATION_MANAGER => 'reservation manager',
            self::RESERVATION => 'reservation',
            self::HANDLING => 'handling',
            self::HANDLING_MANAGER => 'handling manager',

        };
    }
}
