<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\RoomViewTranslations;

class RoomViewTranslationRepository
{
    private $roomViewTranslation;

    public function __construct()
    {
        $this->roomViewTranslation = new RoomViewTranslations;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new RoomViewTranslations;
        $rt->room_view_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->roomViewTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->roomViewTranslation->with('getLang')->where('room_view_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->roomViewTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
