<?php

namespace App\sys\Repository\Accounting;

use App\Models\Accounting\TreeAccountSetting;

class TreeAccountSettingRepository
{
    public function update($data)
    {
        $updated = [];

        foreach ($data as $setting) {
            $record = TreeAccountSetting::where('type', $setting['type'])->first();
            $record->tree_account_id = $setting['tree_account_id'];
            $record->save();

            $updated[] = $record->load('tree');
        }

        return $updated;
    }

    public function getAll()
    {
        return TreeAccountSetting::with('tree')->get();
    }
}
