<?php

namespace App\sys\Repository\General;

use App\Models\General\CompanyTranslation;

class CompanyTranslationRepository
{
    private $companyTranslation;

    public function __construct()
    {
        $this->companyTranslation = new CompanyTranslation;
    }

    public function save($data, $company_id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $company_id);
            }
        }

        return true;
    }

    public function add($data, $company_id)
    {
        $ct = new CompanyTranslation;
        $ct->company_id = $company_id;
        $ct->lang_id = $data['language_id'];
        $ct->name_company = $data['name'];
        $ct->companie_address_1 = $data['companie_address'] ?? null;
        $ct->default_invoice_footer = $data['default_invoice_footer'] ?? null;
        $ct->save();
    }

    public function updated($data)
    {
        $ct = $this->companyTranslation->find($data['id']);
        $ct->name_company = $data['name'] ?? $ct->name_company;
        $ct->companie_address_1 = $data['companie_address'] ?? $ct->companie_address_1;
        $ct->default_invoice_footer = $data['default_invoice_footer'] ?? $ct->default_invoice_footer;
        $ct->save();
    }

    public function get($company_id)
    {
        return $this->companyTranslation->with('getLang')->where('company_id', $company_id)->get();
    }

    public function del($id)
    {
        $ct = $this->companyTranslation->find($id);
        if ($ct) {
            return $ct->delete();
        }

        return false;
    }
}
