<?php

namespace App\sys\Services\Accommodation;

use App\sys\Repository\Accommodation\MealPlanTranslationRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class MealPlanTranslationServices extends Services
{
    private $mealPlanTranslation;

    public function __construct()
    {
        $this->mealPlanTranslation = new MealPlanTranslationRepository;
    }

    public function save(array $data, $id)
    {
        $rules = ['meal_plan_id' => 'required|integer|exists:ac_meal_plans,id'];
        $combinations = [];
        $customErrors = [];
        foreach ($data as $index => $row) {
            $rowId = $row['id'] ?? null;
            $languageId = $row['language_id'] ?? null;
            $rules["$index.id"] = 'sometimes|nullable|exists:ac_meal_plans_translation,id';
            $rules["$index.language_id"] = [
                Rule::requiredIf(empty($rowId)),
                'exists:languages,id',
                Rule::unique('ac_meal_plans_translation', 'lang_id')
                    ->where(fn ($query) => $query->where('meal_plan_id', $id))
                    ->ignore($rowId),
            ];
            $rules["$index.name"] = 'nullable|string|max:255';
            if ($languageId) {
                $key = $id.'-'.$languageId;
                if (in_array($key, $combinations)) {
                    $customErrors["$index.language_id"] = 'Same language distorted with the same Meal Plan.';
                } else {
                    $combinations[] = $key;
                }
            }
        }
        $validator = Validator::make(array_merge($data, ['meal_plan_id' => $id]), $rules);
        $validator->after(function ($validator) use ($customErrors) {
            foreach ($customErrors as $field => $message) {
                $validator->errors()->add($field, $message);
            }
        });
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->mealPlanTranslation->save($data, $id);
    }

    public function get($id)
    {
        return $this->mealPlanTranslation->get($id);
    }

    public function del($id)
    {
        $rules = [
            'id' => 'required|integer|exists:ac_meal_plans_translation,id',
        ];
        $validator = \Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->mealPlanTranslation->del($id);
    }
}
