<?php

namespace App\sys\Services\Accounting;

use App\sys\Repository\Accounting\TreeAccountSettingRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class TreeAccountSettingServices extends Services
{
    private TreeAccountSettingRepository $treeAccountSettingRepository;

    public function __construct()
    {
        $this->treeAccountSettingRepository = new TreeAccountSettingRepository;
    }

    public function update($data)
    {
        $rules = [
            '*' => 'required|array|min:1',
            '*.tree_account_id' => 'required|integer|exists:tree_accounting,id',
            '*.type' => 'required|in:assets,liabilities,expenditure,revenue',
        ];
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->treeAccountSettingRepository->update($data);
    }

    public function getAll()
    {
        return $this->treeAccountSettingRepository->getAll();
    }
}
