<?php

namespace App\sys\Services\Roles_Groups;

use App\sys\Repository\Roles_Groups\RoleRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class RoleService extends Services
{
    protected $rolerepositrey;

    public function __construct(RoleRepository $rolerepositrey)
    {

        $this->rolerepositrey = $rolerepositrey;

    }

    public function getPaginated()
    {
        return $this->rolerepositrey->getPaginated();
    }

    public function create($data)
    {
        $rules = [
            'name' => 'required|string|unique:roles|max:255',
            'description' => 'nullable|string|max:255',
            'permissions' => 'nullable|array',
            'permissions.*' => 'exists:permissions,id',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->rolerepositrey->add($data);

    }

    public function updatee(array $data, $id)
    {
        $rules = [
            'name' => ['sometimes', 'string', 'unique:roles,name,'.$id, 'max:255'],
            'description' => 'sometimes|nullable|string|max:255',
            'permissions' => 'nullable|array',
            'permissions.*' => 'exists:permissions,id',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->rolerepositrey->updated($id, $data);
    }

    public function deletee($id)
    {

        $role = $this->rolerepositrey->find($id);

        if (! $role) {
            $this->setError(['role' => 'Role not found']);

            return false;
        }

        // $role->users()->each(function ($user) {
        //     $user->clearPermissionCache();
        // });

    }

    public function get($id)
    {

        $validator = Validator::make(['id' => $id], [
            'id' => ['required', 'integer', 'exists:roles,id'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $role = $this->rolerepositrey->show($id);

        return $role;
    }

    public function updatePermissions(int $roleId, array $permissionIds)
    {
        $validator = Validator::make([
            'id' => $roleId,
            'permission_ids' => $permissionIds,
        ], [
            'id' => ['required', 'integer', 'exists:roles,id'],
            'permission_ids' => ['sometimes', 'array'],
            'permission_ids.*' => ['integer', 'exists:permissions,id'],
        ]);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $role = $this->rolerepositrey->find($roleId);
        if (! $role) {
            $this->setError(['role' => 'Role not found']);

            return false;
        }

        $this->rolerepositrey->syncPermissions($roleId, $permissionIds);

        // $role->users()->each(function ($user) {
        //     $user->clearPermissionCache();
        // });

        return true;
    }
}
