<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\GuideLanguage\GuideLanguageLangResource;
use App\Http\Resources\GuideLanguageCollection;
use App\Http\Resources\GuideLanguageResource;
use App\sys\ApiResponse;
use App\sys\Services\General\GuideLanguageService;
use App\sys\Services\General\GuideLanguageTranslationService;
use Illuminate\Http\Request;

class GuideLanguageController extends Controller
{
    use ApiResponse;

    protected GuideLanguageService $service;

    protected GuideLanguageTranslationService $translationService;

    public function __construct(GuideLanguageService $service, GuideLanguageTranslationService $translationService)
    {
        $this->service = $service;
        $this->translationService = $translationService;
    }

    public function index()
    {
        $items = $this->service->getPaginated();

        return $this->apiResponse(200, 'success', null, new GuideLanguageCollection($items));
    }

    public function show(int $id)
    {
        $item = $this->service->getById($id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new GuideLanguageResource($item));
    }

    public function store(Request $request)
    {
        $response = $this->service->create($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new GuideLanguageResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->service->update($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new GuideLanguageResource($response));
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->service->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Guide languages deleted successfully', null, null);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getActive()
    {
        $data = $this->service->getActive();
        $collect = new GuideLanguageCollection($data);

        return $this->apiResponse(200, 'Active Guide Languages retrieved successfully', null, $collect);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->translationService->save($request->all(), $id)) {
            $errors = $this->translationService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->service->getByIdWithTranslation($id)) {
            $collection = new GuideLanguageLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->translationService->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->translationService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }
}
