<?php

namespace App\Http\Resources\Accounting;

use App\Http\Resources\Profile\AttachmentResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ConstraintResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id ?? null,
            'year' => $this->year ?? null,
            'type_of_movement_id' => $this->type_of_movement_id ?? null,
            'number_movement' => $this->number_movement ?? null,
            'date' => $this->date ?? null,
            'name' => $this->name ?? null,
            'number_doc' => $this->number_doc ?? null,
            'number_chek' => $this->number_chek ?? null,
            'chek_date' => $this->chek_date ?? null,
            'username' => $this->username ?? null,
            'description' => $this->description ?? null,
            'creation_mode' => $this->creation_mode ?? null,
            'difference' => $this->difference ?? null,
            'total_creditor' => $this->total_creditor ?? null,
            'currency_creditor' => $this->currency_creditor ?? null,
            'total_debit' => $this->total_debit ?? null,
            'currency_debit' => $this->currency_debit ?? null,
            'active' => (bool) $this->active ?? null,
            'user_id' => $this->user_id ?? null,
            'currency_id' => $this->currency_id ?? null,
            'currency_name' => $this->currency->currentTranslation->name ?? $this->currency->name ?? null,
            'currency_transfer_rate' => $this->currency_transfer_rate ?? null,
            'company_id' => $this->company_id ?? null,
            'capture_exchange' => $this->capture_exchange ?? null,
            'type_optional' => $this->type_optional ?? null,
            'invoice_id' => $this->invoice_id ?? null,
            'invoice_serial_num' => $this->whenLoaded('invoice', function () {
                return $this->invoice->serial_num ?? null;
            }),
            'profile_number' => $this->profile->profile_number ?? null,
            'transfers' => TransferResource::collection($this->whenLoaded('transfers')),
            'attachments' => AttachmentResource::collection($this->whenLoaded('attachments')),
            'created_at' => $this->created_at ?? null,
            'updated_at' => $this->updated_at ?? null,
            'created_name' => $this->user->name ?? null,
        ];
    }
}
