<?php

namespace App\Http\Resources\General\Service;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'title' => $this->title,
            'item_code' => $this->item_code,
            'unit_type' => $this->unit_type,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? ServiceTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
