<?php

namespace App\Http\Resources\General;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceHistoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'audit_id' => $this['audit_id'],
            'user_id' => $this['user_id'],
            'user' => $this['user'],
            'old_values' => $this['old_values'],
            'new_values' => $this['new_values'],
            'changed_at' => $this['changed_at'] ? $this['changed_at']->format('Y-m-d H:i:s') : null,
            'event' => $this['event'],
            'ip_address' => $this['ip_address'],
            'user_agent' => $this['user_agent'],
        ];
    }
}
