<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TaxRateAccounting extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'tax_rate_id' => $this->tax_rate_id,
            'tree_account_id' => $this->tree_account_id,
            'currency_id' => $this->currency_id,
            'input_name' => $this->type,
            'currency_name' => $this->currency->name ?? null,
            'tree_account_name' => $this->tree->title ?? null,
            'full_name' => $this->type.'-'.$this->currency?->name ?? null,
        ];
    }
}
