<?php

namespace App\Models\Accounting;

use App\Models\General\Companies;
use App\Models\Profile\Customer;
use App\Models\Profile\Profile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Invoice extends Model implements Auditable
{
    use AuditableTrait,HasFactory;

    protected $table = 'in_invoice';

    protected $fillable = [
        'serial_num',         // string(50): رقم المسلسل الخاص بالفاتورة
        'customer_id',        // int: رقم العميل المرتبط بالفاتورة
        'company_id',         // int: رقم الشركة أو الفرع المسؤول عن الفاتورة
        'invoice_date',       // string(255): تاريخ إصدار الفاتورة
        'recip_date',         // string(255): تاريخ استلام الفاتورة من العميل
        'pay_duration',       // int: مدة السداد بالأيام
        'invoice_date_due',   // string(255): تاريخ الاستحقاق النهائي للدفع
        'invoice_price',      // double: إجمالي قيمة الفاتورة
        'invoice_type',       // int: نوع الفاتورة (نقدي، آجل، إلخ)
        'paid_price',         // double: المبلغ المدفوع من إجمالي الفاتورة
        'paid_date',          // string(255): تاريخ الدفع
        'remaining_price',    // double: المبلغ المتبقي بعد الدفع
        'worthy_days',        // int: عدد الأيام المستحقة للدفع
        'notes',              // text: ملاحظات إضافية عن الفاتورة
        'conditions',         // text: الشروط أو البنود الخاصة بالفاتورة
        'profile_id',
        'next_paid_date',     // date: تاريخ الدفع القادم
    ];

    protected $auditInclude = [
        'serial_num',         // string(50): رقم المسلسل الخاص بالفاتورة
        'customer_id',        // int: رقم العميل المرتبط بالفاتورة
        'company_id',         // int: رقم الشركة أو الفرع المسؤول عن الفاتورة
        'invoice_date',       // string(255): تاريخ إصدار الفاتورة
        'recip_date',         // string(255): تاريخ استلام الفاتورة من العميل
        'pay_duration',       // int: مدة السداد بالأيام
        'invoice_date_due',   // string(255): تاريخ الاستحقاق النهائي للدفع
        'invoice_price',      // double: إجمالي قيمة الفاتورة
        'invoice_type',       // int: نوع الفاتورة (نقدي، آجل، إلخ)
        'paid_price',         // double: المبلغ المدفوع من إجمالي الفاتورة
        'paid_date',          // string(255): تاريخ الدفع
        'remaining_price',    // double: المبلغ المتبقي بعد الدفع
        'worthy_days',        // int: عدد الأيام المستحقة للدفع
        'notes',              // text: ملاحظات إضافية عن الفاتورة
        'conditions',         // text: الشروط أو البنود الخاصة بالفاتورة
        'profile_id',
        'next_paid_date',     // date: تاريخ الدفع القادم
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'created',
        'updated',
    ];

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function company()
    {
        return $this->belongsTo(Companies::class, 'company_id');
    }
}
