<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Currency extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'currencies';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $fillable = [
        'name',
        'symbol',
        'exchange_rate',
        'status',
        'code',
    ];

    protected $casts = [
        'exchange_rate' => 'double',
        'status' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'name',
        'symbol',
        'exchange_rate',
        'status',
        'code',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function services()
    {
        return $this->belongsToMany(Service::class, 'services_currencies', 'currency_id', 'service_id');
    }

    public function servicesCurrencies()
    {
        return $this->hasMany(ServicesCurrencies::class);
    }

    public function translations()
    {
        return $this->hasMany(CurrencyTranslations::class, 'currency_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(CurrencyTranslations::class, 'currency_id')
            ->where('lang_id', app('lang_id'));
    }
}
