<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Model;

class GuideLanguageTranslation extends Model
{
    protected $table = 'guide_language_translation';

    protected $fillable = [
        'guide_language_id',
        'lang_id',
        'name',
    ];

    public function getLang()
    {
        return $this->belongsTo(\App\Models\Languages\Languages::class, 'lang_id');
    }

    public function guideLanguage()
    {
        return $this->belongsTo(GuideLanguage::class, 'guide_language_id');
    }
}
