<?php

namespace App\sys\Enums;

enum Settings: string
{
    case DEFAULT_CURRENCY = 'default_currency'; // العمله الافتراضيه - يتم تعديلها ايضا في table currency
    case NAME_WEBSITE = 'name_website'; // varchar(250) → اسم الموقع
    case WEB_URL = 'web_url'; // varchar(250) → رابط الموقع
    case META_WEBSITE = 'meta_website'; // text → بيانات الميتا الخاصة بالموقع
    case ON_OFF_RELAY = 'on_off_relay'; // int(1) → تفعيل / تعطيل الترحيل
    case MASSAGES_OFF = 'massages_off'; // text → الرسائل في حالة الإيقاف
    case EMAIL_WEBSITE = 'email_website'; // varchar(250) → البريد الإلكتروني للموقع
    case DATE_ISSUACE_RESIDENCY = 'date_issuace_residency'; // int(1) → تاريخ إصدار الإقامة
    case EXPIRATION_PASSPORT = 'expiration_passport'; // int(1) → تاريخ انتهاء جواز السفر
    case GOOGLE_PLUS = 'google+'; // varchar(250) → حساب جوجل بلس
    case META_KEY = 'meta_key'; // text → كلمات الميتا (SEO keywords)
    case ADDRESS = 'addres'; // varchar(250) → العنوان
    case PHONE = 'phone'; // varchar(250) → رقم الهاتف
    case FAX = 'fax'; // varchar(250) → رقم الفاكس

    // Salary / Contract
    case TYPE_PRICE = 'type_price'; // tinyint(1) → نوع السعر
    case MONTH_START_SALARY = 'month_start_salary'; // int(3) → بداية شهر الرواتب
    case MONTH_END_SALARY = 'month_end_salary'; // int(3) → نهاية شهر الرواتب
    case END_CONTRACT = 'end_contract'; // int(3) → نهاية العقد
    case TEXT_AREA_MANAGER = 'text_area_manger'; // text → ملاحظات المدير
    case ONLY_YEAR = 'ony_year'; // int(3) → السنة فقط

    // SMS Settings
    case SMS_ADD_INVOICE = 'sms_add_invoice'; // tinyint(4) → رسالة عند إضافة فاتورة
    case SMS_ADD_RESTORTION = 'sms_add_restortion'; // tinyint(4) → رسالة عند إضافة استرجاع
    case SMS_PAY_INVOICE = 'sms_pay_invoice'; // tinyint(4) → رسالة عند دفع فاتورة
    case SMS_PAY_RESTORTION = 'sms_pay_restortion'; // tinyint(4) → رسالة عند دفع استرجاع
    case SMS_ADD_CLIENT = 'sms_add_client'; // tinyint(4) → رسالة عند إضافة عميل جديد
    case SMS_TEXT_ADD_CLIENT = 'sms_text_add_client'; // text → نص رسالة إضافة العميل
    case SMS_TEXT_PAYMENT_REMINDER = 'sms_text_payment_reminder'; // text → نص تذكير الدفع
    case SMS_REMIND_PAY = 'sms_remind_pay'; // tinyint(4) → تفعيل تذكير الدفع
    case SMS_ANY = 'sms_any'; // text → رسالة عامة
    case SMS_ANY_OPEN = 'sms_any_open'; // text → فتح الرسائل العامة

    // Banks
    case BANKS = 'banks'; // array → البنوك (tree account)
}
