<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\RatingTranslation;

class RatingTranslationRepository
{
    private $ratingTranslation;

    public function __construct()
    {
        $this->ratingTranslation = new RatingTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new RatingTranslation;
        $rt->rating_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->ratingTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->ratingTranslation->with('getLang')->where('rating_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->ratingTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
