<?php

namespace App\sys\Repository\General;

use App\Models\General\DomainTranslation;

class DomainTranslationRepository
{
    private $domainTranslation;

    public function __construct()
    {
        $this->domainTranslation = new DomainTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new DomainTranslation;
        $rt->domain_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->title = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->domainTranslation->find($data['id']);
        $rt->title = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->domainTranslation->with('getLang')->where('domain_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->domainTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
