<?php

namespace App\sys\Repository\General;

use App\Models\General\Settings;
use App\sys\Enums\Settings as SettingsEnum;

class SettingsRepository
{
    public function getByKey($key)
    {
        return Settings::where('key', $key)->first();
    }

    public function getAll()
    {
        return Settings::all();
    }

    public function create($key, $value)
    {
        return Settings::create([
            'key' => $key,
            'value' => $value,
        ]);
    }

    public function updateByKey($key, $value)
    {
        return Settings::where('key', $key)->update(['value' => $value]);
    }

    public function exists($key)
    {
        return Settings::where('key', $key)->exists();
    }

    public function getValue($key)
    {
        $setting = $this->getByKey($key);

        return $setting ? $setting->value : null;
    }

    public function isDefaultCurrencySet()
    {
        return $this->exists(SettingsEnum::DEFAULT_CURRENCY->value);
    }

    public function getDefaultCurrency()
    {
        return $this->getValue(SettingsEnum::DEFAULT_CURRENCY->value);
    }

    /**
     * إنشاء جميع الـ keys من الـ enum في قاعدة البيانات إذا لم تكن موجودة
     */
    public function initializeAllKeys()
    {
        $created = [];
        $existing = [];

        foreach (SettingsEnum::cases() as $case) {
            $key = $case->value;
            if (! $this->exists($key)) {
                // تحديد القيمة الافتراضية بناءً على نوع الـ key
                $defaultValue = $this->getDefaultValueForKey($key);
                $this->create($key, $defaultValue);
                $created[] = $key;
            } else {
                $existing[] = $key;
            }
        }

        return [
            'created' => $created,
            'existing' => $existing,
            'total' => count(SettingsEnum::cases()),
        ];
    }

    /**
     * الحصول على القيمة الافتراضية للـ key
     */
    private function getDefaultValueForKey($key)
    {
        // القيم الافتراضية بناءً على نوع الحقل
        $defaults = [
            SettingsEnum::DEFAULT_CURRENCY->value => null,
            SettingsEnum::ON_OFF_RELAY->value => '0',
            SettingsEnum::DATE_ISSUACE_RESIDENCY->value => '0',
            SettingsEnum::EXPIRATION_PASSPORT->value => '0',
            SettingsEnum::TYPE_PRICE->value => '0',
            SettingsEnum::MONTH_START_SALARY->value => '1',
            SettingsEnum::MONTH_END_SALARY->value => '12',
            SettingsEnum::END_CONTRACT->value => '12',
            SettingsEnum::ONY_YEAR->value => date('Y'),
            SettingsEnum::SMS_ADD_INVOICE->value => '0',
            SettingsEnum::SMS_ADD_RESTORTION->value => '0',
            SettingsEnum::SMS_PAY_INVOICE->value => '0',
            SettingsEnum::SMS_PAY_RESTORTION->value => '0',
            SettingsEnum::SMS_ADD_CLIENT->value => '0',
            SettingsEnum::SMS_REMIND_PAY->value => '0',
            SettingsEnum::BANKS->value => json_encode([]),
        ];

        return $defaults[$key] ?? '';
    }
}
