<?php

namespace App\sys\Services\Profile;

use App\sys\Repository\Profile\AccommodationReservationPriceRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class AccommodationReservationPriceService extends Services
{
    protected AccommodationReservationPriceRepository $priceRepository;

    public function __construct(AccommodationReservationPriceRepository $priceRepository)
    {
        $this->priceRepository = $priceRepository;
    }

    public function getAll(array $filters = [])
    {
        return $this->priceRepository->getAll($filters);
    }

    public function getById(int $id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:pr_accommodation_reservation_prices,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->priceRepository->findByIdOrFail($id);
    }
}
