<?php

namespace App\Http\Controllers;

use App\Models\Airline;
use App\sys\ApiResponse;
use Illuminate\Support\Facades\DB;

class AirLinesControlers extends Controller
{
    use ApiResponse;

    public function search($code = null)
    {
        $air = Airline::when($code, function ($query, $code) {
            $query->where(function ($query) use ($code) {
                $query->where('code', 'like', "%$code%")
                    ->orWhere('name_en', 'like', "%$code%")
                    ->orWhere('name_ar', 'like', "%$code%");
            });
        })
            ->select(
                'id',
                'code',
                DB::raw('COALESCE(name_ar, name_en) as name'),
                DB::raw('CONCAT_WS(" - ", 
                    COALESCE(name_ar, name_en, ""), 
                    code
                ) as display')
            )
            ->when($code, function ($query, $code) {
                // Priority: exact code matches first, then code starts with, then others
                $query->orderByRaw('
                CASE 
                    WHEN code = ? THEN 1
                    WHEN code LIKE ? THEN 2
                    ELSE 3
                END
            ', [$code, "$code%"])
                    ->orderBy('code', 'asc');
            }, function ($query) {
                $query->orderBy('code', 'asc');
            })
            ->paginate();

        return $this->apiResponse(200, 'airline', null, $air);
    }
}
