<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\WorkPeriodHistoryResource;
use App\Http\Resources\WorkPeriodCollection;
use App\Http\Resources\WorkPeriodResource;
use App\sys\ApiResponse;
use App\sys\Services\General\WorkPeriodService;
use Illuminate\Http\Request;

class WorkPeriodController extends Controller
{
    use ApiResponse;

    protected WorkPeriodService $workPeriodService;

    private $workPeriodTranslationService;

    public function __construct(WorkPeriodService $workPeriodService)
    {
        $this->workPeriodService = $workPeriodService;
        $this->workPeriodTranslationService = new \App\sys\Services\General\WorkPeriodTranslationService;
    }

    public function index()
    {
        $items = $this->workPeriodService->getPaginatedWorkPeriod();

        return $this->apiResponse(200, 'success', null, new WorkPeriodCollection($items));
    }

    public function show(int $id)
    {
        $item = $this->workPeriodService->getWorkPeriodById($id);
        if (! $item) {
            $errors = $this->workPeriodService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new WorkPeriodResource($item));
    }

    public function store(Request $request)
    {
        $response = $this->workPeriodService->createWorkPeriod($request->all());
        if (! $response) {
            $errors = $this->workPeriodService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new WorkPeriodResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->workPeriodService->updateWorkPeriod($request->all());
        if (! $response) {
            $errors = $this->workPeriodService->errors();

            return $this->apiResponse(400, 'fail', null, $errors);
        }

        return $this->apiResponse(200, 'success', null, new WorkPeriodResource($response));
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->workPeriodService->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'WorkPeriod deleted successfully', null, null);
        }
        $errors = $this->workPeriodService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getActive()
    {
        $data = $this->workPeriodService->getActive();
        $collect = new \App\Http\Resources\WorkPeriodCollection($data);

        return $this->apiResponse(200, 'Active WorkPeriod retrieved successfully', null, $collect);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->workPeriodTranslationService->save($request->all(), $id)) {
            $errors = $this->workPeriodTranslationService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->workPeriodService->getByIdWithTranslation($id)) {
            $collection = new \App\Http\Resources\General\WorkPeriod\WorkPeriodLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->workPeriodService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->workPeriodTranslationService->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->workPeriodTranslationService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $item = $this->workPeriodService->getWorkPeriodById($id);
        if (! $item) {
            $errors = $this->workPeriodService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        $changes = $this->workPeriodService->getAllChanges($item);

        return $this->apiResponse(200, 'success', null, WorkPeriodHistoryResource::collection($changes));
    }
}
