<?php

namespace App\Http\Controllers\Profile;

use App\Http\Controllers\Controller;
use App\sys\ApiResponse;
use App\sys\Services\Profile\DailyProgramsService;
use Illuminate\Http\Request;

class DailyProgramsController extends Controller
{
    use ApiResponse;

    protected DailyProgramsService $service;

    public function __construct(DailyProgramsService $service)
    {
        $this->service = $service;
    }

    public function show(int $id)
    {
        $item = $this->service->getById($id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new \App\Http\Resources\Profile\DailyProgramsResource($item));
    }

    public function byProfile(int $profileId)
    {
        $items = $this->service->getByProfileId($profileId);
        if ($items === false) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new \App\Http\Resources\Profile\DailyProgramsCollection($items));
    }

    public function store(Request $request)
    {
        return $this->apiResponse(403, 'disabled', ['use profile.store to create daily programs automatically'], null);
    }

    public function update(Request $request)
    {
        return $this->apiResponse(403, 'disabled', ['use profile.update to update daily programs automatically'], null);
    }
}
