<?php

namespace App\Http\Controllers\Roles_Groups;

use App\Http\Controllers\Controller;
use App\Http\Resources\Roles_Groups\GroupCollection;
use App\Http\Resources\Roles_Groups\GroupResource;
use App\sys\ApiResponse;
use App\sys\Services\Roles_Groups\GroupService;

class GroupController extends Controller
{
    use ApiResponse;

    protected $groupservice;

    public function __construct(GroupService $groupservice)
    {
        $this->groupservice = $groupservice;
    }

    public function index()
    {
        $constraints = $this->groupservice->getPaginated();

        return $this->apiResponse(200, 'success', null, new GroupCollection($constraints));
    }

    public function show($id)
    {

        $group = $this->groupservice->get($id);
        if (! $group) {
            $errors = $this->groupservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);

        }

        return $this->apiResponse(200, 'success', null, new GroupResource($group));
    }
}
