<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TransferResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'constraint_id' => $this->constraint_id,
            'name' => $this->name,
            'currency_creditor' => $this->currency_creditor,
            'total_creditor' => $this->creditor,
            'total_debit' => $this->debit,
            'currency_debit' => $this->currency_debit,
            'tree_accounting_id' => $this->tree_accounting_id,
            'cost_center_id' => $this->cost_center_id,
            'currency_id' => $this->currency_id,
            'currency_transfer_rate' => $this->currency_transfer_rate,
            'date' => $this->date,
            // علاقات جديدة:
            'tree_accounting_title' => $this->treeAccounting && $this->treeAccounting->currentTranslation
                ? $this->treeAccounting->currentTranslation->title
                : ($this->treeAccounting->title ?? null),
            'tree_accounting_serial_number_dight' => $this->treeAccounting->serial_number_dight ?? null,
            'currency_name' => $this->currency->name ?? null,
            'currency_code' => $this->currency->code ?? null,
            'currency_symbol' => $this->currency->symbol ?? null,
            'constraint_description' => $this->constraint->description ?? null,
            'cost_center_name' => $this->costCenter->name ?? null,
        ];
    }
}
