<?php

namespace App\Http\Resources\General\Service;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'services_id' => $this->services_id,
            'lang_id' => $this->lang_id,
            'title' => $this->title,
            'lang_name' => $this->relationLoaded('language') ? $this->language->name ?? null : null,
            'lang_code' => $this->relationLoaded('language') ? $this->language->code ?? null : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
