<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class PaytypeAccounting extends Model
{
    protected $table = 'pay_type_accounting';

    protected $fillable = [
        'pay_type_id',
        'currency_id',
        'tree_accounting_transfer_id',
        'tree_account_commission_id',
        'min_amount',
        'max_amount',
    ];

    protected $casts = [
        'min_amount' => 'decimal:2',
        'max_amount' => 'decimal:2',
    ];

    public function paytype()
    {
        return $this->belongsTo(Paytype::class, 'pay_type_id');
    }

    public function currency()
    {
        return $this->belongsTo(\App\Models\General\Currency::class, 'currency_id');
    }

    public function treeAccountingTransfer()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_accounting_transfer_id');
    }

    public function treeAccountCommission()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_account_commission_id');
    }
}
