<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Country extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'code',
        'is_active',
        'is_default',
    ];

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'name',
        'code',
        'is_active',
        'is_default',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(CountryTranslation::class, 'country_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(CountryTranslation::class, 'country_id')
            ->where('lang_id', app('lang_id'));
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }
}
