<?php

namespace App\Models\General;

use App\Models\Languages\Languages;
use Illuminate\Database\Eloquent\Model;

class TaxRateTranslation extends Model
{
    protected $table = 'tax_rate_translation';

    protected $fillable = [
        'lang_id',
        'title',
        'tax_rate_id',
        'created_at',
        'updated_at',
    ];

    public function getLang()
    {
        return $this->belongsTo(Languages::class, 'lang_id');
    }
}
