<?php

namespace App\Models\Profile;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyPrograms extends Model
{
    use SoftDeletes;

    protected $table = 'pr_daily_programs';

    protected $fillable = [
        'profile_id',   // int(11), nullable → مفتاح أجنبي للـ Profile::class
        'day_number',   // int(11), default 1 → رقم اليوم (اليوم الأول، الثاني...)
        'day_date',     // date, nullable → تاريخ اليوم نفسه
    ];

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function invoiceServices()
    {
        return $this->hasMany(\App\Models\invoice\InvoiceServices::class, 'daily_program_id');
    }
}
