<?php

namespace App\Providers;

use App\Models\User;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    public function boot(): void
    {

        $this->registerPolicies();

        Gate::before(function (User $user, $permissionName) {

            $overrides = $user->getOverrideRulesList();

            if (isset($overrides[$permissionName])) {
                $result = $overrides[$permissionName] === 'allow';
                Log::info('Override result: '.($result ? 'true' : 'false'));

                return $result;
            }

            $rolePermissions = $user->getRolePermissionsList();

            $hasPermission = in_array($permissionName, $rolePermissions);

            return $hasPermission ? true : null;
        });
    }
}
