<?php

namespace App\sys;

use App\Models\Languages\Languages;

trait HasTranslationSync
{
    public function syncTranslations($model, bool $withReturn = false, string $relation = 'translations', string $langKey = 'lang_id')
    {

        $translations = $model->$relation ?? collect();
        $existingLangIds = $translations->pluck($langKey)->toArray();

        $activeLanguages = Languages::where('is_active', 1)->get();

        $translationModel = $model->$relation()->getRelated(); // موديل الترجمة
        $defaultValues = collect($model->getAttributes())
            ->only($translationModel->getFillable())
            ->toArray();

        foreach ($activeLanguages as $lang) {
            if (! in_array($lang->id, $existingLangIds)) {
                $model->$relation()->create(array_merge(
                    $defaultValues,
                    [$langKey => $lang->id]
                ));
            }
        }

        if ($withReturn) {
            return $model->load($relation);
        }
    }
}
