<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\MealPlansTranslations;

class MealPlanTranslationRepository
{
    private $mealPlanTranslation;

    public function __construct()
    {
        $this->mealPlanTranslation = new MealPlansTranslations;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $mp = new MealPlansTranslations;
        $mp->meal_plan_id = $id;
        $mp->lang_id = $data['language_id'];
        $mp->name = $data['name'];
        $mp->save();
    }

    public function updated($data)
    {
        $mp = $this->mealPlanTranslation->find($data['id']);
        $mp->name = $data['name'];
        $mp->save();
    }

    public function get($id)
    {
        return $this->mealPlanTranslation->with('getLang')->where('meal_plan_id', $id)->get();
    }

    public function del($id)
    {
        $mp = $this->mealPlanTranslation->find($id);
        if ($mp) {
            return $mp->delete();
        }

        return false;
    }
}
