<?php

namespace App\sys\Repository\General;

use App\Models\General\TransportationModesTranslation;

class TransportationModesTranslationRepository
{
    private $translation;

    public function __construct()
    {
        $this->translation = new TransportationModesTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {

        $tr = new TransportationModesTranslation;
        $tr->tranortation_id = $id;
        $tr->lang_id = $data['language_id'];
        $tr->name = $data['name'];
        $tr->save();
    }

    public function updated($data)
    {
        $tr = $this->translation->find($data['id']);
        $tr->name = $data['name'];
        $tr->save();
    }

    public function get($id)
    {
        return $this->translation->with('translations')->where('tranortation_id', $id)->get();
    }

    public function del($id)
    {
        $tr = $this->translation->find($id);
        if ($tr) {
            return $tr->delete();
        }

        return false;
    }
}
