<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\SettingsResource;
use App\sys\ApiResponse;
use App\sys\Services\General\SettingsService;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    use ApiResponse;

    protected SettingsService $settingsService;

    public function __construct(SettingsService $settingsService)
    {
        $this->settingsService = $settingsService;
    }

    /**
     * عرض جميع الإعدادات
     */
    public function index()
    {
        $settings = $this->settingsService->getAllSettings();

        return $this->apiResponse(200, 'success', null, SettingsResource::collection($settings));
    }

    /**
     * عرض إعداد محدد
     */
    public function show(string $key)
    {
        $setting = $this->settingsService->getSetting($key);

        if (! $setting) {
            return $this->apiResponse(400, 'fail', ['الإعداد المطلوب غير موجود'], null);
        }

        return $this->apiResponse(200, 'success', null, new SettingsResource($setting));
    }

    /**
     * إنشاء إعداد جديد
     */
    public function store(Request $request)
    {
        if ($settings = $this->settingsService->createSetting($request->all())) {
            return $this->apiResponse(200, 'success', null, SettingsResource::collection($settings));
        }

        $errors = $this->settingsService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    /**
     * تحديث إعداد محدد
     */
    public function update(Request $request)
    {
        if ($settings = $this->settingsService->updateSetting($request->all())) {
            return $this->apiResponse(200, 'success', null, SettingsResource::collection($settings));
        }

        $errors = $this->settingsService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    /**
     * الحصول على جميع الـ enums
     */
    public function getEnums()
    {
        $enums = [];
        foreach (\App\sys\Enums\Settings::cases() as $case) {
            $enums[] = $case->value;
        }

        return $this->apiResponse(200, 'success', null, $enums);
    }

    /**
     * تهيئة جميع الـ keys من الـ enum في قاعدة البيانات
     */
    public function initialize()
    {
        $result = $this->settingsService->initializeAllKeys();

        return $this->apiResponse(200, 'success', null, [
            'message' => 'تم تهيئة الإعدادات بنجاح',
            'created' => $result['created'],
            'existing' => $result['existing'],
            'total' => $result['total'],
            'created_count' => count($result['created']),
            'existing_count' => count($result['existing']),
        ]);
    }
}
