<?php

namespace App\Http\Middleware;

use App\Models\Languages\Languages;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LanguageManager
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $langId = $request->header('x-lang') ?? 0;
        $language = Languages::find($langId) ?? Languages::where('is_active', 1)->first();
        app()->setLocale($language->code ?? 'en');
        config(['app.fallback_locale' => $language->code ?? 'en']);
        app()->instance('lang_id', $language->id ?? 0);
        config(['pdf_custom.direction' => $language->rtl ? 'rtl' : 'ltr']);

        return $next($request);
    }
}
