<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class PaytypeAccountingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'currency_id' => $this->currency_id,
            'percentage' => $this->percentage,
            'tree_accounting_transfer_id' => $this->tree_accounting_transfer_id,
            'tree_account_commission_id' => $this->tree_account_commission_id,
            'currency_name' => $this->currency->name ?? null,
            'tree_accounting_transfer_name' => $this->treeAccountingTransfer->title ?? null,
            'tree_account_commission_name' => $this->treeAccountCommission->title ?? null,
            'min_amount' => $this->min_amount,
            'max_amount' => $this->max_amount,
        ];
    }
}
