<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class PaytypeResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->relationLoaded('currentTranslation') && $this->currentTranslation
                ? ($this->currentTranslation->title != null ? $this->currentTranslation->title : $this->title)
                : $this->title,
            'type' => $this->type,
            'is_protected' => $this->is_protected,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'accounting' => $this->whenLoaded('accounting', function () {
                return PaytypeAccountingResource::collection($this->accounting);
            }),
        ];
    }
}
