<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
