<?php

namespace App\Http\Resources\General\WorkPeriod;

use Illuminate\Http\Resources\Json\JsonResource;

class WorkPeriodLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->period,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? WorkPeriodTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
