<?php

namespace App\Http\Resources;

use App\Http\Resources\General\Service\ServiceTranslationResource;
use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'title' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'is_fixed_price' => $this->is_fixed_price,
            'item_code' => $this->item_code,
            'unit_type' => $this->unit_type,
            'active' => $this->is_active,
            'services_currencies' => $this->whenLoaded('servicesCurrencies', function () {
                return $this->servicesCurrencies->map(function ($serviceCurrency) {
                    return [
                        'id' => $serviceCurrency->id,
                        'currency_id' => $serviceCurrency->currency_id,
                        'currency_name' => $serviceCurrency->currency->name ?? null,
                        'tree_accounting_id' => $serviceCurrency->tree_accounting_id,
                        'tree_income_accounting_id' => $serviceCurrency->tree_income_accounting_id,
                        'tree_accounting_name' => $serviceCurrency->relationLoaded('treeAccounting') ?

                            $serviceCurrency->treeAccounting->title ?? null : null,
                        'tree_income_accounting_name' => $serviceCurrency->relationLoaded('treeIncomeAccounting') ?
                            $serviceCurrency->treeIncomeAccounting->title ?? null
                            : null,
                        'child_price' => $serviceCurrency->child_price,
                        'adult_price' => $serviceCurrency->adult_price,
                    ];
                });
            }),
            'currencies' => $this->whenLoaded('currencies', fn () => CurrencyResource::collection($this->currencies)),
            'suppliers' => $this->whenLoaded('suppliers', fn () => SupplierResource::collection($this->suppliers)),
            'users' => $this->whenLoaded('users', fn () => UserResource::collection($this->users)),
            'user_ids' => $this->whenLoaded('users', fn () => $this->users->pluck('id')->toArray()),
            'translations' => $this->whenLoaded('translations', fn () => ServiceTranslationResource::collection($this->translations)),
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
