<?php

namespace App\Models\Accounting;

use App\Models\General\Currency;
use App\Models\Profile\Profile;
use Illuminate\Database\Eloquent\Model;

class UnpostedCollections extends Model
{
    protected $table = 'unposted_collections';

    protected $fillable = [
        'profile_id',        // int(11) Profile::class - رقم البروفايل
        'currency_id',       // bigint(20) Country::class - العملة
        'currency_rate',     // double - سعر الصرف
        'date',              // date - تاريخ العملية
        'next_date',         // date - التاريخ التالي (لو متكرر أو متابعة)
        'amount',            // double - المبلغ الأساسي
        'pay_type_id',       // int(11) Paytype::class - طريقة الدفع
        'transaction_amount', // double -  العموله  صافي العملية بعد الخصم
        'fee_amount',        // double - العمولة / الرسوم
        'reference',         // varchar(200) - المرجع / رقم العملية
        'details',           // varchar(600) - تفاصيل إضافية
        'customer_name',     // varchar(300) - اسم العميل
        'is_posted',         // tinyint(4) - تم الترحيل (0/1)
        'posted_at',         // timestamp - وقت الترحيل
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function paytype()
    {
        return $this->belongsTo(Paytype::class, 'pay_type_id');
    }
}
