<?php

namespace App\Models\Profile;

use App\Models\General\Currency;
use Illuminate\Database\Eloquent\Model;

class AccommodationReservationPrices extends Model
{
    protected $table = 'pr_accommodation_reservation_prices';

    protected $fillable = [
        'currency_id',
        'amount',
        'tax',
        'reservation_id',
        'profile_id',
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function reservation()
    {
        return $this->belongsTo(AccommodationReservation::class, 'reservation_id');
    }
}
