<?php

namespace App\Models\invoice;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class InvoiceServices extends Model implements Auditable
{
    use AuditableTrait;

    protected $table = 'invoice_services';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $casts = [
        'air_taxs' => 'array',
    ];

    protected $fillable = [
        'travel_tourism_type',            // enum('tour_guide','accommodation','tour_reps','dining_entertainment','attractions_temples','additional_services','daily_transportation','single_transportation') → نوع الخدمة
        'travel_tourism_steps',           // tinyint(4) → قبل أو بعد الفاتورة
        'travel_tourism_done',            // tinyint(1) → استلم الخدمة ولا لا
        'service_id',                     // int(11) → رقم الخدمة Service::class
        'domain_id',                      // int(11) → الدومين المرتبط
        'invoice_id',                     // int(11) → رقم الفاتورة
        'supplier_id',                    // int(11) → رقم المورد
        'category_id',                    // int(11) → كاتيجوري التور جايد
        'pay_type_id',                    // int(11) → نوع الدفع (ID)
        'pay_type',                       // int(11) → نوع الدفع (قيمة)
        'reserve_number',                 // varchar(255) → رقم الحجز
        'vatt_amount',                    // double → قيمة الضريبة المضافة
        'vatt_Supplier',                  // double → ضريبة المورد
        'profit',                         // double → المكسب قبل عمولة الموظف
        'employee_tax',                   // double → ضريبة عمولة الموظف
        'last_profit',                    // double → المكسب بعد عمولة الموظف
        'taxtree',                        // int(11) → شجرة الضريبة
        'supplirTree',                    // int(11) → شجرة المورد
        'serviceTree',                    // int(11) → شجرة الخدمة
        'payTree',                        // int(11) → شجرة الدفع
        'serviceTreeIncom',               // int(11) → شجرة إيرادات الخدمة
        'serviceTypeAndPayType',          // int(11) → ربط الخدمة مع الدفع
        'paid_rice',                      // double → ما تم دفعه
        'supplier_currency_id',           // int(11) → عملة المورد
        'supplier_currency_transfer_rate', // float → معدل تحويل عملة المورد
        'client_currency_id',             // int(11) → عملة العميل
        'client_currency_transfer_rate',  // float → معدل تحويل عملة العميل
        'extra_service_price',            // float → سعر الخدمة الإضافية
        'extra_service_tree',             // int(11) → شجرة الخدمة الإضافية
        'created',                        // datetime → تاريخ الإنشاء
        'modified',                       // date → تاريخ التعديل

        // الشراء
        'purchase_price',                 // double → سعر الشراء
        'purchase_commission',            // double → عمولة الشراء
        'purchase_rate',                  // double → ريت الشراء
        'purchase_tax_id',                // int(11) → ضريبة الشراء (ID)
        'purchase_tax_amount',            // double → قيمة الضريبة على الشراء
        'purchase_currency_id',           // int(11) → عملة الشراء
        'purchase_tax_rate',              // double → نسبة الضريبة على الشراء

        // البيع
        'sale_price',                     // double → سعر البيع
        'sale_commission',                // double → عمولة البيع
        'sale_rate',                      // double → ريت البيع
        'sale_tax_id',                    // int(11) → ضريبة البيع (ID)
        'sale_tax_amount',                // double → قيمة الضريبة على البيع
        'sale_currency_id',               // int(11) → عملة البيع
        'sale_tax_rate',                  // double → نسبة الضريبة على البيع

        'type',                           // enum('credit','debit') → نوع الحركة
        'model_type',                     // varchar(300) → اسم الموديل المرتبط
        'model_id',                       // int(11) → رقم الموديل المرتبط
        'profile_id',                     // int(11) → رقم البروفايل
        'reservation_model',
        'reservation_id',

        'daily_program_id', // int: رقم البرنامج اليومي //DailyPrograms::class
        'nationality_id',   // int|null: Nationality::class
        'adults_count',     // int: عدد الكبار
        'children_count',   // int: عدد الأطفال
        'adult_price',      // float: سعر الفرد البالغ
        'child_price',      // float: سعر الطفل
        'adult_total',      // float: إجمالي الكبار
        'child_total',      // float: إجمالي الأطفال
        'grand_total',      // float: الإجمالي الكلي
        'executive_id',     // int|null: مسؤول التنفيذ // User::class
        'currency_id',      // Currency::class
        'currency_rate',     // currency->rate

        // tour_guide specific
        'guide_id',          // User::class
        'people_count',      // int
        'daily_cost',        // float
        'tip_amount',        // float
        'total_tips',        // float
        'total_tax',         // float
        'notes',             // string|null

        // selling fields (handling selling prices per service)
        'selling_currency_id',  // int|null: Currency used for selling
        'selling_price',        // double: total selling amount (before tax)
        'selling_total_tax',    // double: total selling tax amount
        'selling_adult_price',  // double: optional per-adult selling price (for temples / tour_guide / dining)
        'selling_child_price',  // double: optional per-child selling price (for temples / tour_guide / dining)

        // transportation specific
        'city_id',          // int
        'city_to_id',       // int
        'execution_date',   // date

        // Handling
        'is_by_handling',
        'salse_id',
        'created_by',
        'updated_by',
        'paid_to_supplier',
        'remaining_to_supplier',
        'is_paid',
        'next_pay_date',
        'status', // enum('pending','confirmed','cancelled','done')
        // flights specific
        'pnr_number',
        'office_id',
        'ticket_date',
        'direction_type',
        'economy_class',
        'supplier_amount',
        'air_taxs',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'travel_tourism_type',            // enum('tour_guide','accommodation','tour_reps','dining_entertainment','attractions_temples','additional_services','daily_transportation','single_transportation') → نوع الخدمة
        'travel_tourism_steps',           // tinyint(4) → قبل أو بعد الفاتورة
        'travel_tourism_done',            // tinyint(1) → استلم الخدمة ولا لا
        'service_id',                     // int(11) → رقم الخدمة Service::class
        'domain_id',                      // int(11) → الدومين المرتبط
        'invoice_id',                     // int(11) → رقم الفاتورة
        'supplier_id',                    // int(11) → رقم المورد
        'pay_type_id',                    // int(11) → نوع الدفع (ID)
        'pay_type',                       // int(11) → نوع الدفع (قيمة)
        'reserve_number',                 // varchar(255) → رقم الحجز
        'vatt_amount',                    // double → قيمة الضريبة المضافة
        'vatt_Supplier',                  // double → ضريبة المورد
        'profit',                         // double → المكسب قبل عمولة الموظف
        'employee_tax',                   // double → ضريبة عمولة الموظف
        'last_profit',                    // double → المكسب بعد عمولة الموظف
        'taxtree',                        // int(11) → شجرة الضريبة
        'supplirTree',                    // int(11) → شجرة المورد
        'serviceTree',                    // int(11) → شجرة الخدمة
        'payTree',                        // int(11) → شجرة الدفع
        'serviceTreeIncom',               // int(11) → شجرة إيرادات الخدمة
        'serviceTypeAndPayType',          // int(11) → ربط الخدمة مع الدفع
        'paid_rice',                      // double → ما تم دفعه
        'supplier_currency_id',           // int(11) → عملة المورد
        'supplier_currency_transfer_rate', // float → معدل تحويل عملة المورد
        'client_currency_id',             // int(11) → عملة العميل
        'client_currency_transfer_rate',  // float → معدل تحويل عملة العميل
        'extra_service_price',            // float → سعر الخدمة الإضافية
        'extra_service_tree',             // int(11) → شجرة الخدمة الإضافية
        'created',                        // datetime → تاريخ الإنشاء
        'modified',                       // date → تاريخ التعديل

        // الشراء
        'purchase_price',                 // double → سعر الشراء
        'purchase_commission',            // double → عمولة الشراء
        'purchase_rate',                  // double → ريت الشراء
        'purchase_tax_id',                // int(11) → ضريبة الشراء (ID)
        'purchase_tax_amount',            // double → قيمة الضريبة على الشراء
        'purchase_currency_id',           // int(11) → عملة الشراء
        'purchase_tax_rate',              // double → نسبة الضريبة على الشراء

        // البيع
        'sale_price',                     // double → سعر البيع
        'sale_commission',                // double → عمولة البيع
        'sale_rate',                      // double → ريت البيع
        'sale_tax_id',                    // int(11) → ضريبة البيع (ID)
        'sale_tax_amount',                // double → قيمة الضريبة على البيع
        'sale_currency_id',               // int(11) → عملة البيع
        'sale_tax_rate',                  // double → نسبة الضريبة على البيع

        'type',                           // enum('credit','debit') → نوع الحركة
        'model_type',                     // varchar(300) → اسم الموديل المرتبط
        'model_id',                       // int(11) → رقم الموديل المرتبط
        'reservation_model',
        'reservation_id',

        'daily_program_id', // int: رقم البرنامج اليومي //DailyPrograms::class
        'nationality_id',   // int|null: Nationality::class
        'adults_count',     // int: عدد الكبار
        'children_count',   // int: عدد الأطفال
        'adult_price',      // float: سعر الفرد البالغ
        'child_price',      // float: سعر الطفل
        'adult_total',      // float: إجمالي الكبار
        'child_total',      // float: إجمالي الأطفال
        'grand_total',      // float: الإجمالي الكلي
        'executive_id',     // int|null: مسؤول التنفيذ // User::class
        'currency_id',      // Currency::class
        'currency_rate',     // currency->rate

        // tour_guide specific
        'guide_id',          // User::class
        'people_count',      // int
        'daily_cost',        // float
        'tip_amount',        // float
        'total_tips',        // float
        'total_tax',         // float
        'notes',             // string|null

        // selling fields
        'selling_currency_id',
        'selling_price',
        'selling_total_tax',
        'selling_adult_price',
        'selling_child_price',

        // flights specific
        'air_taxs',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function model(): MorphTo
    {
        return $this->morphTo('model', 'model_type', 'model_id');
    }

    public function reservation(): MorphTo
    {
        return $this->morphTo('reservation', 'reservation_model', 'reservation_id');
    }

    // Relationships for dynamic service types
    public function dailyProgram()
    {
        return $this->belongsTo(\App\Models\Profile\DailyPrograms::class, 'daily_program_id');
    }

    public function nationality()
    {
        return $this->belongsTo(\App\Models\General\Nationality::class, 'nationality_id');
    }

    public function executive()
    {
        return $this->belongsTo(\App\Models\User::class, 'executive_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(\App\Models\User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(\App\Models\User::class, 'updated_by');
    }

    public function salseUser()
    {
        return $this->belongsTo(\App\Models\User::class, 'salse_id');
    }

    public function currency()
    {
        return $this->belongsTo(\App\Models\General\Currency::class, 'currency_id');
    }

    public function company()
    {
        return $this->belongsTo(\App\Models\General\Companies::class, 'company_id');
    }

    public function city()
    {
        return $this->belongsTo(\App\Models\General\City::class, 'city_id');
    }

    public function cityTo()
    {
        return $this->belongsTo(\App\Models\General\City::class, 'city_to_id');
    }

    public function operationData()
    {
        return $this->belongsTo(\App\Models\General\OperationData::class, 'operation_data_id');
    }

    public function supplier()
    {
        return $this->belongsTo(\App\Models\Suppliers\Suppliers::class, 'supplier_id');
    }

    public function category()
    {
        return $this->belongsTo(\App\Models\General\Category::class, 'category_id');
    }

    public function service()
    {
        return $this->belongsTo(\App\Models\General\Service::class, 'service_id');
    }

    public function profile()
    {
        return $this->belongsTo(\App\Models\Profile\Profile::class, 'profile_id');
    }

    // Tour guide specific
    public function guide()
    {
        return $this->belongsTo(\App\Models\User::class, 'guide_id');
    }

    public function guideLanguage()
    {
        return $this->belongsTo(\App\Models\General\GuideLanguage::class, 'guide_language_id');
    }

    public function taxes()
    {
        return $this->hasMany(\App\Models\invoice\InvoiceServicesTax::class, 'invoice_services_id');
    }

    public function sellingTaxes()
    {
        return $this->hasMany(\App\Models\invoice\InvoiceServicesSellingTax::class, 'invoice_services_id');
    }

    // Flights specific relationships
    public function segments()
    {
        return $this->hasMany(\App\Models\invoice\Segments::class, 'invoice_services_id');
    }

    public function airlineTickets()
    {
        return $this->hasMany(\App\Models\invoice\AirlineTickets::class, 'invoice_service_id');
    }

    // Derived field for tour_guide provider indicator
    public function getServiceProviderAttribute()
    {
        if (! is_null($this->supplier_id)) {
            return 'supplier_id';
        }
        if (! is_null($this->guide_id)) {
            return 'guide_id';
        }

        return null;
    }
}
