<?php

namespace App\sys\Repository\Accounting;

use App\Models\Accounting\PaytypeTranslation;

class PaytypeTranslationRepository
{
    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new PaytypeTranslation;
        $rt->pay_type_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->title = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = PaytypeTranslation::find($data['id']);
        $rt->title = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return PaytypeTranslation::with('getLang')->where('pay_type_id', $id)->get();
    }

    public function del($id)
    {
        $rt = PaytypeTranslation::find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
