<?php

namespace App\sys\Repository\General;

use App\Models\General\CurrencyTranslations;

class CurrencyTranslationRepository
{
    private $currencyTranslation;

    public function __construct()
    {
        $this->currencyTranslation = new CurrencyTranslations;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new CurrencyTranslations;
        $rt->currency_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->symbol = $data['symbol'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->currencyTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->symbol = $data['symbol'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->currencyTranslation->with('getLang')->where('currency_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->currencyTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
