<?php

namespace App\sys\Repository\Languages;

use App\Models\General\LanguageTranslation;
use App\Models\Languages\Languages;
use App\sys\Services\General\Translation\TranslationService;

class LanguagesRepository
{
    protected $translationService;

    private $lang;

    private $columns = [
        'id' => 'id',
        'name' => 'name',
        'active' => 'is_active',
        'rtl' => 'rtl',
        'code' => 'code',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
    ];

    public function __construct(Languages $lang, TranslationService $translationService)
    {
        $this->lang = $lang;
        $this->translationService = $translationService;
    }

    public function add($data)
    {
        $lang = $this->lang->newInstance();
        $lang->name = $data['name'];
        $lang->is_active = $data['active'];
        $lang->rtl = $data['rtl'];
        $lang->code = $data['code'];
        $lang->save();

        // Copy translations from English (ID 1)
        $englishTranslations = LanguageTranslation::where('language_id', 3)->get();
        $newTranslations = [];
        $now = now();

        foreach ($englishTranslations as $translation) {
            $newTranslations[] = [
                'language_id' => $lang->id,
                'key' => $translation->key,
                'controller_name' => $translation->controller_name,
                'value' => $translation->value, // Default to English value
                'is_translated' => 0,
                'created_at' => $now,
                'updated_at' => $now,
            ];
        }

        if (! empty($newTranslations)) {
            LanguageTranslation::insert($newTranslations);
            $this->translationService->publish($lang->id);
        }

        return $lang;
    }

    public function updated($data)
    {
        $lan = $this->lang->find($data['id']);
        $lan->name = $data['name'] ?? $lan->name;
        $lan->is_active = $data['active'] ?? $lan->is_active;
        $lan->rtl = $data['rtl'] ?? $lan->rtl;
        $lan->code = $data['code'] ?? $lan->code;
        $lan->save();

        return $lan;
    }

    public function gets()
    {
        $column = request('sort_by', null);
        $order = request('sort_order', 'asc');
        $name = request('name', null);
        $limit = request('limit', 15);

        return $this->lang->when('name', function ($query) use ($name) {
            $query->where('name', 'like', '%'.$name.'%');
        })->when($column, function ($query) use ($column, $order) {
            if (array_key_exists($column, $this->columns)) {
                $query->orderBy($this->columns[$column], $order);
            }
        })->paginate($limit);
    }

    public function getById($id)
    {
        return $this->lang->find($id);
    }

    public function getActive()
    {
        return $this->lang->where('is_active', 1)->get();
    }
}
