<?php

namespace App\sys\Repository\Roles_Groups;

use App\Models\Group;

class GroupRepository
{
    protected $group;

    public function __construct(Group $group)
    {

        $this->group = $group;

    }

    protected $columns = [
        'id' => 'id',
        'name' => 'name',
        'created_at' => 'created_at',
    ];

    public function getPaginated()
    {
        // 1. جلب متغيرات الطلب
        $column = request('sort_by', null);
        $order = request('sort_order', 'desc'); // 'desc' كقيمة افتراضية
        $name = request('name', null);
        $limit = request('limit', 15);

        $query = $this->group->query()
            ->when($name, function ($q, $name) {
                $q->where('name', 'LIKE', "%$name%");
            });

        if ($column && array_key_exists($column, $this->columns)) {
            $query->orderBy($this->columns[$column], $order);
        } else {
            $query->orderBy('created_at', $order);
        }

        // 4. إرجاع النتيجة مع التقسيم
        return $query->paginate($limit);
    }

    public function deletee($id)
    {
        return $this->group->destroy($id);
    }

    public function find($id)
    {
        return $this->group->find($id);
    }
}
